#include <iostream>
using namespace std;

/**
  Constructeur definissant le terrain
  @param[in] w - largeur du rectangle
  @param[in] h - hauteur du rectangle
  @param[in] v - status de la vente
*/

Terrain::Terrain(double w, double h, bool v)
: m_r(w, h), m_vendu(v)
{}

/**
  Affiche les caracteristiques du terrain
*/
void Terrain::afficher() const
{
  cout<<"vendu = "<<not dispo()<<" surf = "<<m_r.surface()<<" ";
  m_r.afficher();
}

/**
  Accesseur de la surface
  @return la surface
*/
double Terrain::surface() const
{
  return m_r.surface();
}

/**
  Accesseur de la disponibilite
  @return la disponibilite
*/
bool Terrain::dispo() const
{
  return not m_vendu;
}

