#include <iostream>
using namespace std;
/**
  Constructeur par defaut
*/
Rectangle::Rectangle()
: m_largeur(0.0), m_hauteur(0.0)
{}

/**
  Constructeur normal
  @param[in] w - largeur
  @param[in] h - hauteur
*/
Rectangle::Rectangle(double w, double h)
{
  assign(w, h);
}

/**
  Accesseur de la largeur
  @return largeur du rectangle
*/
double Rectangle::getLargeur() const
{
  return m_largeur;
}

/**
  Accesseur de la hauteur
  @return hauteur du rectangle
*/
double Rectangle::getHauteur() const
{
  return m_hauteur;
}

/**
  Methode d'assignation
  @param[in] w - largeur
  @param[in] h - hauteur
*/  
void Rectangle::assign(double w, double h)
{
  m_largeur = (w >= 0 ? w : 0.0);
  m_hauteur = (h >= 0 ? h : 0.0);
}

/**
  Methode d'affichage
*/
void Rectangle::afficher() const
{
  cout<<"rect: L="<<getLargeur()<<" H="<<getHauteur()<<endl;
}

/**
  Methode pour le calcul de la surface
  @return surface du rectangle
*/
double Rectangle::surface() const
{
  return getLargeur() * getHauteur();
}

/**
  Methode pour le calcul du perimètre
  @return perimètre du rectangle
*/
double Rectangle::perimetre() const
{
  return 2*(getLargeur() + getHauteur());
}

