#include <iostream>
#include <fstream>
using namespace std;

/**
  Constructeur par defaut
*/
Promoteur::Promoteur()
: m_tr()
{}

/**
  Charge les donnees depuis un fichier
  @param[in] fn - nom du fichier des donnees
*/
void Promoteur::charger(const string& fn)
{
  ifstream is(fn.c_str());
  double w, h;
  char v;
  is>>w;
  while (not is.eof())
  {
    is>>h>>v;
    bool b = (v == 'v');
    m_tr.push_back(Terrain(w, h, b));
    is>>w;
  }
  is.close();
}

/**
  Affiche les caracteristiques des terrains
*/
void Promoteur::afficher() const
{
  for (int j = 0; j < m_tr.size(); ++j)
  {
    m_tr[j].afficher();
  }
}

/**
  Calcul des ventes et des disponibilites
*/
void Promoteur::calculer() const
{
  double sv = 0.0, sd = 0.0;
  for (int j = 0; j < m_tr.size(); ++j)
  {
    if (m_tr[j].dispo())
    {
      sd += m_tr[j].surface();
    }
    else
    {
      sv += m_tr[j].surface();
    }
  }
  cout<<"Surface vente "<<sv<<endl;
  cout<<"Surface dispo "<<sd<<endl;
}

