
def afficherCarre(t, n):
    """  Affiche un TCarre
 
     :param t: un ITableau
     :param n: ordre de t
    """
    for j in range(1, n+1):
        for k in range(1, n+1):
            print("{:3d}".format(evalCase(t, j, k, n)), end="")
        print()


def indexTab2d(j, k, ncols):
    """  Index linéaire d'un tableau bi-dimensionnel
 
     :param j: index-ligne à partir de 1
     :param k: index-colonne à partir de 1
     :param ncols: nombre de colonnes du tableau
     :return: l'index linéaire de (j,k)
    """
    return ((j - 1) * ncols + k - 1)


def evalCase(t, j, k, n):
    """  Valeur de l'élément d'un TCarre
 
     :param t: un ITableau
     :param j: index-ligne à partir de 1
     :param k: index-colonne à partir de 1
     :param n: ordre de t
     :return: la valeur de l'élément en (j,k) de t
    """
    return t[indexTab2d(j, k, n)]


def fixerCase(t, j, k, n, valeur):
    """  Fixe l'élément d'un TCarre
 
     :param t: un ITableau
     :param j: index-ligne à partir de 1
     :param k: index-colonne à partir de 1
     :param n: ordre de t
     :param valeur: valeur à fixer
    """
    t[indexTab2d(j, k, n)] = valeur


def initialiserCarre(t, n):
    """  Initialise à zéro un TCarre
 
     :param t: un ITableau
     :param n: ordre de t
    """
    for j in range(1, n+1):
        for k in range(1, n+1):
            fixerCase(t, j, k, n, 0)

