import java.util.Scanner;

public class UtilsTM {


/**
  Affiche un TCarre
  @param[in] t - un ITableau
  @param[in] n - ordre de t
*/

public static void afficherCarre(final int[] t, int n)
{
  for (int j = 1; j <= n; ++j)
  {
    for (int k = 1; k <= n; ++k)
    {
      System.out.printf("%3d",evalCase(t,j,k,n));
    }
    System.out.println();
  }
}

/**
  Index linéaire d'un tableau bi-dimensionnel
  @param[in] j - index-ligne à partir de 1
  @param[in] k - index-colonne à partir de 1
  @param[in] ncols - nombre de colonnes du tableau
  @return l'index linéaire de (j,k)
*/

public static int indexTab2d(int j, int k, int ncols)
{
  return ((j - 1) * ncols + k - 1);
}

/**
  Valeur de l'élément d'un TCarre
  @param[in] t - un ITableau
  @param[in] j - index-ligne à partir de 1
  @param[in] k - index-colonne à partir de 1
  @param[in] n - ordre de t
  @return la valeur de l'élément en (j,k) de t
*/

public static int evalCase(final int[] t, int j, int k, int n)
{
  return t[indexTab2d(j,k,n)];
}

/**
  Fixe l'élément d'un TCarre
  @param[in,out] t - un ITableau
  @param[in] j - index-ligne à partir de 1
  @param[in] k - index-colonne à partir de 1
  @param[in] n - ordre de t
  @param[in] valeur - valeur à fixer
*/

public static void fixerCase(int[] t, int j, int k, int n, int valeur)
{
  t[indexTab2d(j,k,n)] = valeur;
}

/**
  Initialise à zéro un TCarre
  @param[out] t - un ITableau
  @param[in] n - ordre de t
*/

public static void initialiserCarre(int[] t, int n)
{
  for (int j = 1; j <= n; ++j)
  {
    for (int k = 1; k <= n; ++k)
    {
      fixerCase(t,j,k,n,0);
    }
  }
}

}
