#ifndef UTILSTM
#define UTILSTM
#include <iostream>
#include <iomanip>
using namespace std;

namespace UtilsTM {

// Prédéclarations
int evalCase(const ITableau& t,int ix,int jx,int n);

/**
  Affiche un TCarre
  @param[in] t - un ITableau
  @param[in] n - ordre de t
*/

void afficherCarre(const ITableau& t, int n)
{
  for (int j = 1; j <= n; ++j)
  {
    for (int k = 1; k <= n; ++k)
    {
      cout<<setw(3)<<evalCase(t,j,k,n);
    }
    cout<<endl;
  }
}

/**
  Index linéaire d'un tableau bi-dimensionnel
  @param[in] j - index-ligne à partir de 1
  @param[in] k - index-colonne à partir de 1
  @param[in] ncols - nombre de colonnes du tableau
  @return l'index linéaire de (j,k)
*/

int indexTab2d(int j, int k, int ncols)
{
  return ((j - 1) * ncols + k - 1);
}

/**
  Valeur de l'élément d'un TCarre
  @param[in] t - un ITableau
  @param[in] j - index-ligne à partir de 1
  @param[in] k - index-colonne à partir de 1
  @param[in] n - ordre de t
  @return la valeur de l'élément en (j,k) de t
*/

int evalCase(const ITableau& t, int j, int k, int n)
{
  return t[indexTab2d(j,k,n)];
}

/**
  Fixe l'élément d'un TCarre
  @param[in,out] t - un ITableau
  @param[in] j - index-ligne à partir de 1
  @param[in] k - index-colonne à partir de 1
  @param[in] n - ordre de t
  @param[in] valeur - valeur à fixer
*/

void fixerCase(ITableau& t, int j, int k, int n, int valeur)
{
  t[indexTab2d(j,k,n)] = valeur;
}

/**
  Initialise à zéro un TCarre
  @param[out] t - un ITableau
  @param[in] n - ordre de t
*/

void initialiserCarre(ITableau& t, int n)
{
  for (int j = 1; j <= n; ++j)
  {
    for (int k = 1; k <= n; ++k)
    {
      fixerCase(t,j,k,n,0);
    }
  }
}

}
#endif
