
def anagrammiqueTab(t1, t2, n):
    """  Prédicat d'anagrammie de deux ITableaux
 
     :param t1: un ITableau
     :param t2: un ITableau
     :param n: nombre d'éléments dans [0..TMAX[
     :return: Vrai si t1 et t2 sont anagrammes, Faux sinon
    """
    for j in range(n - 1, 0-1, -1):
        k = 0
        while k <= j and t2[k] != t1[j]:
            k += 1
        if k <= j:
            t2[j], t2[k] = t2[k], t2[j]
        else:
            return False
    return True


def copierTab(t, n, copie):
    """  Copie n valeurs d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
     :param copie: un ITableau
    """
    for j in range(0, n):
        copie[j] = t[j]


def extraireTab(t, ndebut, nfin, trs, ntrs):
    """  Extrait un sous-tableau d'un ITableau
 
     :param t: un ITableau
     :param ndebut: indice de début de t
     :param nfin: indice (exclus) de fin de t
     :param trs: un ITableau
     :param ntrs: nombre de valeurs de trs
     :return: le nombre de valeurs de trs
    """
    for j in range(ndebut, nfin):
        trs[ntrs] = t[j]
        ntrs += 1
    return ntrs


def extremumsTab(t, n):
    """  Extremums de n valeurs d'un ITableau (algorithme ruse)
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [2..TMAX[
     :return: le tuple (valeur du minimum, valeur du maximum)
    """
    vmin = t[0]
    vmax = (t[1] if n >= 2 else t[0])
    if vmax < vmin:
        vmin, vmax = vmax, vmin
    for j in range(n % 2, n, 2):
        if t[j] < t[j + 1]:
            if t[j] < vmin:
                vmin = t[j]
            if vmax < t[j + 1]:
                vmax = t[j + 1]
        else:
            if t[j + 1] < vmin:
                vmin = t[j + 1]
            if vmax < t[j]:
                vmax = t[j]
    return (vmin, vmax)


def identiquesTab(t1, t2, n):
    """  Prédicat de ITableaux identiques
 
     :param t1: un ITableau
     :param t2: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
     :return: Vrai si t1 et t2 sont identiques, Faux sinon
    """
    rs = True
    j = 0
    while j < n and rs:
        rs = (t1[j] == t2[j])
        j += 1
    return rs


def indiceMaxTab(t, n):
    """  Indice du maximum d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [1..TMAX[
     :return: l'indice du maximum des n valeurs de t
    """
    imax = 0
    vmax = t[imax]
    for j in range(1, n):
        if vmax < t[j]:
            imax = j
            vmax = t[imax]
    return imax


def indiceMinTab(t, n):
    """  Indice du minimum d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [1..TMAX[
     :return: l'indice du minimum des n valeurs de t
    """
    imin = 0
    vmin = t[imin]
    for j in range(1, n):
        if t[j] < vmin:
            imin = j
            vmin = t[imin]
    return imin


def initialiserTab(t, n, valeur):
    """  Initialise n valeurs d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
     :param valeur: valeur d'initialisation
    """
    for j in range(0, n):
        t[j] = valeur


def maximumTab(t, n):
    """  Maximum d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [1..TMAX[
     :return: le maximum des n valeurs de t
    """
    vmax = t[0]
    for j in range(1, n):
        if vmax < t[j]:
            vmax = t[j]
    return vmax


def minimumTab(t, n):
    """  Minimum d'un Tableau
 
     :param t: un Tableau
     :param n: nombre de valeurs dans [1..TMAX[
     :return: le minimum des n valeurs de t
    """
    vmin = t[0]
    for j in range(1, n):
        if t[j] < vmin:
            vmin = t[j]
    return vmin


def minmaxTab(t, n):
    """  Extremums d'un ITableau (algorithme naif)
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [1..TMAX[
     :return: le tuple (valeur du minimum, valeur du maximum)
    """
    vmin, vmax = t[0], t[0]
    for j in range(1, n):
        if t[j] < vmin:
            vmin = t[j]
        elif vmax < t[j]:
            vmax = t[j]
    return (vmin, vmax)


def noccurrencesTab(t, n, valeur):
    """  Nombre d'occurrences d'une valeur d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
     :param valeur: la valeur
     :return: le nombre d'occurrences de valeur dans les n valeurs de t
    """
    rs = 0
    for j in range(0, n):
        if t[j] == valeur:
            rs += 1
    return rs


def partitionnerTab(t, n):
    """  Partitionne un ITableau (neg à gauche, pos à droite)
 
     :param t: un ITableau
     :param n: ordre du tableau dans [0..TMAX[
    """
    j = 0
    k = n - 1
    while j < k:
        while j < k and t[j] < 0:
            j += 1
        while j < k and t[k] >= 0:
            k -= 1
        if j < k:
            t[j], t[k] = t[k], t[j]
            j += 1
            k -= 1


def permutationTab(t, n):
    """  Prédicat de permutation d'un ITableau
 
     :param t: un ITableau
     :param n: ordre du tableau dans [0..TMAX[
     :return: Vrai si t est une permutation d'ordre n, Faux sinon
    """
    TMAX = len(t)
    vu = [False for x in range(TMAX)]
    rs = True
    j = 0
    while rs and j < n:
        valeur = t[j] - 1
        if valeur < 0 or valeur >= n or vu[valeur]:
            rs = False
        else:
            vu[valeur] = True
            j += 1
    return rs


def rechseqTab(t, n, valeur):
    """  Recherche d'une valeur dans un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
     :param valeur: valeur à rechercher
     :return: la position de valeur dans t, -1 sinon
    """
    j = 0
    while j < n and t[j] != valeur:
        j += 1
    return (j if j < n else -1)


def renverserTab(t, n):
    """  Renverse les valeurs d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
    """
    j = 0
    k = n - 1
    while j < k:
        t[j], t[k] = t[k], t[j]
        j += 1
        k -= 1


def sommeTab(t, n):
    """  Somme de valeurs d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX[
     :return: Somme de n valeurs de t
    """
    somme = 0
    for j in range(0, n):
        somme += t[j]
    return somme

