#ifndef UTILSTBOPERS
#define UTILSTBOPERS

namespace UtilsTBOpers {

// Prédéclaration
void tbpermuter2i(int& a,int& b);

/**
  Prédicat d'anagrammie de deux ITableaux
  @param[in,out] t1 - un ITableau
  @param[in,out] t2 - un ITableau
  @param[in] n - nombre d'éléments dans [0..TMAX[
  @return Vrai si t1 et t2 sont anagrammes, Faux sinon
*/

bool anagrammiqueTab(ITableau& t1, ITableau& t2, int n)
{
  for (int j = n - 1; j >= 0; --j)
  {
    int k = 0;
    while (k <= j && t2[k] != t1[j])
    {
      ++k;
    }
    if (k <= j)
    {
      tbpermuter2i(t2[j],t2[k]);
    }
    else
    {
      return false;
    }
  }
  return true;
}

/**
  Copie n valeurs d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
  @param[out] copie - un ITableau
*/

void copierTab(const ITableau& t, int n, ITableau& copie)
{
  for (int j = 0; j < n; ++j)
  {
    copie[j] = t[j];
  }
}

/**
  Extrait un sous-tableau d'un ITableau
  @param[in] t - un ITableau
  @param[in] ndebut - indice de début de t
  @param[in] nfin - indice (exclus) de fin de t
  @param[in,out] trs - un ITableau
  @param[in] ntrs - nombre de valeurs de trs
  @return le nombre de valeurs de trs
*/

int extraireTab(const ITableau& t, int ndebut, int nfin, ITableau& trs, int ntrs)
{
  for (int j = ndebut; j < nfin; ++j)
  {
    trs[ntrs] = t[j];
    ++ntrs;
  }
  return ntrs;
}

/**
  Extremums de n valeurs d'un ITableau (algorithme ruse)
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [2..TMAX[
  @param[out] vmin - valeur du minimum
  @param[out] vmax - valeur du maximum
*/

void extremumsTab(const ITableau& t, int n, int& vmin, int& vmax)
{
  vmin = t[0];
  vmax = (n >= 2 ? t[1] : t[0]);
  if (vmax < vmin)
  {
    tbpermuter2i(vmin,vmax);
  }
  for (int j = n % 2; j < n; j += 2)
  {
    if (t[j] < t[j + 1])
    {
      if (t[j] < vmin)
      {
        vmin = t[j];
      }
      if (vmax < t[j + 1])
      {
        vmax = t[j + 1];
      }
    }
    else
    {
      if (t[j + 1] < vmin)
      {
        vmin = t[j + 1];
      }
      if (vmax < t[j])
      {
        vmax = t[j];
      }
    }
  }
}

/**
  Prédicat de ITableaux identiques
  @param[in] t1 - un ITableau
  @param[in] t2 - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
  @return Vrai si t1 et t2 sont identiques, Faux sinon
*/

bool identiquesTab(const ITableau& t1, const ITableau& t2, int n)
{
  bool rs = true;
  int j = 0;
  while (j < n && rs)
  {
    rs = (t1[j] == t2[j]);
    ++j;
  }
  return rs;
}

/**
  Indice du maximum d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [1..TMAX[
  @return l'indice du maximum des n valeurs de t
*/

int indiceMaxTab(const ITableau& t, int n)
{
  int imax = 0;
  int vmax = t[imax];
  for (int j = 1; j < n; ++j)
  {
    if (vmax < t[j])
    {
      imax = j;
      vmax = t[imax];
    }
  }
  return imax;
}

/**
  Indice du minimum d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [1..TMAX[
  @return l'indice du minimum des n valeurs de t
*/

int indiceMinTab(const ITableau& t, int n)
{
  int imin = 0;
  int vmin = t[imin];
  for (int j = 1; j < n; ++j)
  {
    if (t[j] < vmin)
    {
      imin = j;
      vmin = t[imin];
    }
  }
  return imin;
}

/**
  Initialise n valeurs d'un ITableau
  @param[out] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
  @param[in] valeur - valeur d'initialisation
*/

void initialiserTab(ITableau& t, int n, int valeur)
{
  for (int j = 0; j < n; ++j)
  {
    t[j] = valeur;
  }
}

/**
  Maximum d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [1..TMAX[
  @return le maximum des n valeurs de t
*/

int maximumTab(const ITableau& t, int n)
{
  int vmax = t[0];
  for (int j = 1; j < n; ++j)
  {
    if (vmax < t[j])
    {
      vmax = t[j];
    }
  }
  return vmax;
}

/**
  Minimum d'un Tableau
  @param[in] t - un Tableau
  @param[in] n - nombre de valeurs dans [1..TMAX[
  @return le minimum des n valeurs de t
*/

int minimumTab(const ITableau& t, int n)
{
  int vmin = t[0];
  for (int j = 1; j < n; ++j)
  {
    if (t[j] < vmin)
    {
      vmin = t[j];
    }
  }
  return vmin;
}

/**
  Extremums d'un ITableau (algorithme naif)
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [1..TMAX[
  @param[out] vmin - valeur du minimum
  @param[out] vmax - valeur du maximum
*/

void minmaxTab(const ITableau& t, int n, int& vmin, int& vmax)
{
  vmin = t[0];
  vmax = t[0];
  for (int j = 1; j < n; ++j)
  {
    if (t[j] < vmin)
    {
      vmin = t[j];
    }
    else if (vmax < t[j])
    {
      vmax = t[j];
    }
  }
}

/**
  Nombre d'occurrences d'une valeur d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
  @param[in] valeur - la valeur
  @return le nombre d'occurrences de valeur dans les n valeurs de t
*/

int noccurrencesTab(const ITableau& t, int n, int valeur)
{
  int rs = 0;
  for (int j = 0; j < n; ++j)
  {
    if (t[j] == valeur)
    {
      ++rs;
    }
  }
  return rs;
}

/**
  Partitionne un ITableau (neg à gauche, pos à droite)
  @param[in,out] t - un ITableau
  @param[in] n - ordre du tableau dans [0..TMAX[
*/

void partitionnerTab(ITableau& t, int n)
{
  int j = 0;
  int k = n - 1;
  while (j < k)
  {
    while (j < k && t[j] < 0)
    {
      ++j;
    }
    while (j < k && t[k] >= 0)
    {
      --k;
    }
    if (j < k)
    {
      tbpermuter2i(t[j],t[k]);
      ++j;
      --k;
    }
  }
}

/**
  Prédicat de permutation d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - ordre du tableau dans [0..TMAX[
  @return Vrai si t est une permutation d'ordre n, Faux sinon
*/

bool permutationTab(const ITableau& t, int n)
{
  bool vu[TMAX] = {false};
  bool rs = true;
  int j = 0;
  while (rs && j < n)
  {
    int valeur = t[j] - 1;
    if (valeur < 0 || valeur >= n || vu[valeur])
    {
      rs = false;
    }
    else
    {
      vu[valeur] = true;
      ++j;
    }
  }
  return rs;
}

/**
  Recherche d'une valeur dans un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
  @param[in] valeur - valeur à rechercher
  @return la position de valeur dans t, -1 sinon
*/

int rechseqTab(const ITableau& t, int n, int valeur)
{
  int j = 0;
  while (j < n && t[j] != valeur)
  {
    ++j;
  }
  return (j < n ? j : -1);
}

/**
  Renverse les valeurs d'un ITableau
  @param[in,out] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
*/

void renverserTab(ITableau& t, int n)
{
  int j = 0;
  int k = n - 1;
  while (j < k)
  {
    tbpermuter2i(t[j],t[k]);
    ++j;
    --k;
  }
}

/**
  Somme de valeurs d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX[
  @return Somme de n valeurs de t
*/

int sommeTab(const ITableau& t, int n)
{
  int somme = 0;
  for (int j = 0; j < n; ++j)
  {
    somme += t[j];
  }
  return somme;
}

/**
  Permutation du contenu de deux entiers
  @param[in,out] a - un entier
  @param[in,out] b - un entier
*/

void tbpermuter2i(int& a, int& b)
{
  int tmp = a;
  a = b;
  b = tmp;
}

}
#endif
