#ifndef UTILSTBOPERS
#define UTILSTBOPERS
#include <stdio.h>
#include <stdbool.h>
//enum { TMAX=... };
//typedef int Tableau[TMAX];

void copierTab(const Tableau t,int n,Tableau copie)
{
  int k;
  for (k = 0 ; k < n ; k)
  {
    copie[k] = t[k];
  }
}

void extraireTab(const Tableau t,int ndebut,int nfin,Tableau trs,int* ntrs)
{
  int k;
  for (k = ndebut ; k < nfin ; ++k)
  {
    trs[*ntrs] = t[k];
    *ntrs += 1;
  }
}

void tbpermuter2i(int* a,int* b);
void extremumsTab(const Tableau t,int n,int* vmin,int* vmax)
{
  *vmin = t[1];
  *vmax = (n >= 2 ? t[1]: t[0]);
  if (*vmax < *vmin)
  {
    tbpermuter2i(vmin,vmax);
  }
  int k = n%2; // 0 ou 1;
  while (k < n)
  {
    if (t[k] < t[k+1])
    {
      if (t[k] < *vmin)
      {
        *vmin = t[k];
      }
      if (*vmax < t[k+1])
      {
        *vmax = t[k+1];
      }
    }
    else
    {
      if (t[k+1] < *vmin)
      {
        *vmin = t[k+1];
      }
      if (*vmax < t[k])
      {
        *vmax = t[k];
      }
    }
    k += 2;
  }
}

bool identiquesTab(const Tableau t1,const Tableau t2,int n)
{
  bool rs = true;
  int k = 0;
  while (k < n && rs)
  {
    rs = (t1[k] == t2[k]);
    k += 1;
  }
  return rs;
}

int indiceMaxTab(const Tableau t,int n)
{
  int imax = 0; // indice du max
  int vmax = t[imax]; // valeur du max
  int k;
  for (k = 1 ; k < n ; ++k)
  {
    if (vmax < t[k])
    {
      imax = k;
      vmax = t[imax];
    }
  }
  return imax;
}

int indiceMinTab(const Tableau t,int n)
{
  int imin = 0; // indice du min
  int vmin = t[imin]; // valeur du min
  int k;
  for (k = 1 ; k < n ; ++k)
  {
    if (t[k] < vmin)
    {
      imin = k;
      vmin = t[imin];
    }
  }
  return imin;
}

void initialiserTab(Tableau t,int n,int valeur)
{
  int k;
  for (k = 0 ; k < n ; ++k)
  {
    t[k] = valeur;
  }
}

int maximumTab(const Tableau t,int n)
{
  int vmax = t[0];
  int k;
  for (k = 1 ; k < n ; ++k)
  {
    if (vmax < t[k])
    {
      vmax = t[k];
    }
  }
  return vmax;
}

int minimumTab(const Tableau t,int n)
{
  int vmin = t[0];
  int k;
  for (k = 1 ; k < n ; ++k)
  {
    if (t[k] < vmin)
    {
      vmin = t[k];
    }
  }
  return vmin;
}

void minmaxTab(const Tableau t,int n,int* vmin,int* vmax)
{
  *vmin = t[0];
  *vmax = t[0];
  int k;
  for (k = 1 ; k < n ; ++k)
  {
    if (t[k] < *vmin)
    {
      *vmin = t[k];
    }
    else if (*vmax < t[k])
    {
      *vmax = t[k];
    }
  }
}

int noccurrencesTab(const Tableau t,int n,int valeur)
{
  int rs = 0;
  int k;
  for (k=0 ; k<n ; ++k)
  {
    if (t[k] == valeur)
    {
      rs += 1;
    }
  }
  return rs;
}

void tbpermuter2i(int* a,int* b);
void partitionnerTab(Tableau t,int n)
{
  int j = 0;
  int k = n-1;
  int tmp;
  while (j < k)
  {
     while (j < k && t[j] < 0)
     {
         j += 1;
     }
     while (j < k && t[k] >= 0)
     {
         k -= 1;
     }
     if (j < k)
     {
         tbpermuter2i(&t[j],&t[k]);
         j += 1;
         k -= 1;
     }
  }
}

bool permutationTab(const Tableau t,int n)
{
  bool vu[TMAX] = {false};
  bool rs = true;
  int valeur;
  int k;
  for (k = 0; rs && k < n; ++k)
  {
    valeur = t[k];
    if (valeur < 1 || valeur > n || vu[valeur])
    {
      rs = false;
    }
    else
    {
      vu[valeur] = true;
    }
  }
  return rs;
}

int rechseqTab(const Tableau t,int n,int valeur)
{
   int j = 0;
   while (j < n && t[j] != valeur)
   {
      j += 1;
   }
   return (j < n ? j : -1);
}

void tbpermuter2i(int* a,int* b);
void renverserTab(Tableau t,int n)
{
  int j = 0;
  int k = n-1;
  int tmp;
  while (j < k)
  {
    tbpermuter2i(&t[j],&t[k]);
    j += 1;
    k -= 1;
  }
}

int sommeTab(const Tableau t,int n)
{
  int somme = 0;
  int k;
  for (k = 0 ; k < n ; ++k)
  {
    somme += t[k];
  }
  return somme;
}

void tbpermuter2i(int* a,int* b);
bool anagrammiqueTab(Tableau t1, Tableau t2, int n)
{
  int j;
  for (j = n-1; j >= 0; --j)
  {
    int k = 0;
    while (k <= j && t2[k] != t1[j])
    {
      k += 1;
    }
    if (k <= j)
    {
      tbpermuter2i(&t2[j],&t2[k]);
    }
    else
    {
      return false;
    }
  }
  return true;
}

void tbpermuter2i(int* a,int* b)
{
   int tmp = *a; *a = *b; *b = tmp;
}
#endif

