
def afficherTab(t, n):
    """  Affichage d'un ITableau
 
     :param t: un ITableau
     :param n: nombre de valeurs dans [0..TMAX]
    """
    print("[", end="")
    for j in range(0, n):
        print(t[j], " ", sep="", end="")
    print("]")


def saisirTab(t):
    """  Saisie de valeurs dans un ITableau
 
     :param t: un ITableau
     :return: le nombre de valeurs saisies dans [1..TMAX]
    """
    TMAX = len(t)
    n = -1
    while not (1 <= n and n <= TMAX):
        print("Nombre de valeurs dans [1..", TMAX, "]? ", sep="", end="")
        n = int(input())
    for j in range(0, n):
        print("t[", j, "]? ", sep="", end="")
        t[j] = int(input())
    return n


def saisirTabSentinelle(t):
    """  Saisie de valeurs dans un ITableau
 
     :param t: un ITableau
     :return: le nombre de valeurs saisies dans [0..TMAX]
    """
    sentinelle = int(input("Valeur de la sentinelle? "))
    tmax1 = len(t) - 1
    n = 0
    valeur = int(input("Premiere valeur? "))
    while valeur != sentinelle and n < tmax1:
        t[n] = valeur
        n += 1
        valeur = int(input("Valeur suivante? "))
    if valeur != sentinelle:
        t[n] = valeur
        n += 1
        print("Plus de place")
    if n == 0:
        print("Serie vide")
    return n

