import java.util.Scanner;

public class UtilsTB {


/**
  Affichage d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX]
*/

public static void afficherTab(final int[] t, int n)
{
  System.out.print("[");
  for (int j = 0; j < n; ++j)
  {
    System.out.print(t[j] + " ");
  }
  System.out.println("]");
}

/**
  Saisie de valeurs dans un ITableau
  @param[out] t - un ITableau
  @return le nombre de valeurs saisies dans [1..TMAX]
*/

public static int saisirTab(int[] t)
{
  final int TMAX = t.length;
  Scanner input = new Scanner(System.in);
  int n = 0;
  while (!(1 <= n && n <= TMAX))
  {
    System.out.print("Nombre de valeurs dans [1.." + TMAX + "]? ");
    n = input.nextInt();
  }
  for (int j = 0; j < n; ++j)
  {
    System.out.print("t[" + j + "]? ");
    t[j] = input.nextInt();
  }
  return n;
}

/**
  Saisie de valeurs dans un ITableau
  @param[out] t - un ITableau
  @return le nombre de valeurs saisies dans [0..TMAX]
*/

public static int saisirTabSentinelle(int[] t)
{
  Scanner input = new Scanner(System.in);
  int sentinelle;
  System.out.print("Valeur de la sentinelle? ");
  sentinelle = input.nextInt();
  int tmax1 = t.length - 1;
  int n = 0;
  int valeur;
  System.out.print("Premiere valeur? ");
  valeur = input.nextInt();
  while (valeur != sentinelle && n < tmax1)
  {
    t[n] = valeur;
    ++n;
    System.out.print("Valeur suivante? ");
    valeur = input.nextInt();
  }
  if (valeur != sentinelle)
  {
    t[n] = valeur;
    ++n;
    System.out.println("Plus de place");
  }
  if (n == 0)
  {
    System.out.println("Serie vide");
  }
  return n;
}

}
