#ifndef UTILSTB
#define UTILSTB
#include <iostream>
using namespace std;

namespace UtilsTB {


/**
  Affichage d'un ITableau
  @param[in] t - un ITableau
  @param[in] n - nombre de valeurs dans [0..TMAX]
*/

void afficherTab(const ITableau& t, int n)
{
  cout<<"[";
  for (int j = 0; j < n; ++j)
  {
    cout<<t[j]<<" ";
  }
  cout<<"]"<<endl;
}

/**
  Affiche n valeurs d'un tableau d'entiers
  @param[in] t - un tableau d'entiers
  @param[in] n - nombre de valeurs dans [0..TMAX]
*/

void afficherTabCC(const int t[], int n)
{
  cout<<"[";
  for (int j = 0; j < n; ++j)
  {
    cout<<t[j]<<" ";
  }
  cout<<"]"<<endl;
}

/**
  Saisie de valeurs dans un ITableau
  @param[out] t - un ITableau
  @return le nombre de valeurs saisies dans [1..TMAX]
*/

int saisirTab(ITableau& t)
{
  int n = 0;
  while (!(1 <= n && n <= TMAX))
  {
    cout<<"Nombre de valeurs dans [1.."<<TMAX<<"]? ";
    cin>>n;
  }
  for (int j = 0; j < n; ++j)
  {
    cout<<"t["<<j<<"]? ";
    cin>>t[j];
  }
  return n;
}

/**
  Saisie de valeurs dans un tableau d'entiers
  @param[out] t - un tableau d'entiers
  @return le nombre de valeurs saisies dans [1..TMAX]
*/

int saisirTabCC(int t[])
{
  int n = 0;
  while (!(1 <= n && n <= TMAX))
  {
    cout<<"Nombre de valeurs dans [1.."<<TMAX<<"]? ";
    cin>>n;
  }
  for (int j = 0; j < n; ++j)
  {
    cout<<"t["<<j<<"? ";
    cin>>t[j];
  }
  return n;
}

/**
  Saisie de valeurs dans un ITableau
  @param[out] t - un ITableau
  @return le nombre de valeurs saisies dans [0..TMAX]
*/

int saisirTabSentinelle(ITableau& t)
{
  int sentinelle;
  cout<<"Valeur de la sentinelle? ";
  cin>>sentinelle;
  int tmax1 = TMAX - 1;
  int n = 0;
  int valeur;
  cout<<"Premiere valeur? ";
  cin>>valeur;
  while (valeur != sentinelle && n < tmax1)
  {
    t[n] = valeur;
    ++n;
    cout<<"Valeur suivante? ";
    cin>>valeur;
  }
  if (valeur != sentinelle)
  {
    t[n] = valeur;
    ++n;
    cout<<"Plus de place"<<endl;
  }
  if (n == 0)
  {
    cout<<"Serie vide"<<endl;
  }
  return n;
}

}
#endif
