#include <stdbool.h>
#include "UtilsTM.c"
//const int TMAX = 100;
//typedef int TCarre[TMAX];

int sommePartielle(const TCarre t,int ideb,int jdeb,int iincr,int jincr,int n)
{
  int rs=0;
  int ix=ideb, jx=jdeb;
  int k;
  for (k=1; k<=n; ++k)
  {
    rs += evalCase(t,ix,jx,n);
    ix += iincr;
    jx += jincr;
  }
  return rs;
}

bool semiCMagique(const TCarre t,int n)
{
  bool rs=true;
  int somme=n*(n*n+1)/2;
  int ix;
  for (ix=1; ix<=n && rs; ++ix)
  {
    rs = rs && (sommePartielle(t,ix,1,0,1,n)==somme);
  }
  int jx;
  for (jx=1; jx<=n && rs; ++jx)
  {
    rs = rs && (sommePartielle(t,1,jx,1,0,n)==somme);
  }
  rs = rs && (sommePartielle(t,1,1,1,1,n)==somme);
  rs = rs && (sommePartielle(t,1,n,1,-1,n)==somme);
  return rs;
}

bool cmagique(const TCarre t,int n)
{
  return permutationTab(t,n*n) && semiCMagique(t,n);
}

int suivant(int k,int n)
{
  int rs = k+1;
  if (rs > n)
  {
    rs = 1;
  }
  return rs;
}

int precedent(int k,int n)
{
  int rs = k-1;
  if (rs < 1)
  {
    rs = n;
  }
  return rs;
}

void creerCMagique1(TCarre t,int n)
{
  int nxn = n*n;
  int ix = 1;
  int jx = n/2+1;
  fixerCase(t,ix,jx,n,1);
  int val;
  for(val=2; val<=nxn; ++val)
  {
    int isucc = precedent(ix,n);
    int jsucc = suivant(jx,n);
    if (evalCase(t,isucc,jsucc,n)==0)
    {
      ix = isucc;
      jx = jsucc;
    }
    else
    {
      ix = suivant(ix,n);
      //jx = precedent(jsucc,n);
    }
    fixerCase(t,ix,jx,n,val);
  }
}

void creerCMagique2(TCarre t, int n)
{
  int nxn = n*n;
  int ix = (n+1)/2+1;
  int jx = (n+1)/2;
  fixerCase(t,ix,jx,n,1);
  int val;
  for(val=2; val<=nxn; ++val)
  {
    int isucc = suivant(ix,n);
    int jsucc = suivant(jx,n);
    if (evalCase(t,isucc,jsucc,n) == 0)
    {
      ix = isucc;
      jx = jsucc;
    }
    else
    {
      ix = suivant(isucc, n);
      //jx = precedent(jsucc, n);
    }
    fixerCase(t, ix, jx, n, val);
  }
}

