import UtilsTM
import UtilsTB
import UtilsTBOpers
TMAX = 100
""" Taille maximale du tableau """


def sommePartielle(c, ideb, jdeb, iincr, jincr, n):
    """  Somme partielle depuis une case
 
     :param c: 
     :param ideb: indice début ligne
     :param jdeb: indice début colonne
     :param iincr: incrément selon les lignes
     :param jincr: incrément selon les colonnes
     :param n: ordre de c
     :return: La somme de n éléments de c en partant de (ideb,jdeb)
    """
    rs = 0
    ix = ideb
    jx = jdeb
    for k in range(1, n+1):
        rs += UtilsTM.evalCase(c, ix, jx, n)
        ix += iincr
        jx += jincr
    return rs


def semiCMagique(c, n):
    """  Prédicat de carre semi-magique
 
     :param c: un TCarre
     :param n: ordre de c
     :return: Vrai si c est un carré semi-magique d'ordre n
    """
    rs = True
    sth = (n * (n * n + 1)) // 2
    k = 1
    while k <= n and rs:
        rs = rs and (sommePartielle(c, k, 1, 0, 1, n) == sth)
        k += 1
    k = 1
    while k <= n and rs:
        rs = rs and (sommePartielle(c, 1, k, 1, 0, n) == sth)
        k += 1
    rs = rs and (sommePartielle(c, 1, 1, 1, 1, n) == sth)
    rs = rs and (sommePartielle(c, 1, n, 1, -1, n) == sth)
    return rs


def cmagique(c, n):
    """  Prédicat de carré magique
 
     :param c: un TCarre
     :param n: ordre de c
     :return: Vrai si c est un carré magique d'ordre n
    """
    b1 = UtilsTBOpers.permutationTab(c, n * n)
    b2 = semiCMagique(c, n)
    return (b1 and b2)


def PGTMagicite():
    c = [0 for x in range(TMAX)]
    nelems = UtilsTB.saisirTab(c)
    n = int(input("Ordre n? "))
    UtilsTM.afficherCarre(c, n)
    
    b1 = UtilsTBOpers.permutationTab(c, n * n)
    b2 = semiCMagique(c, n)
    b3 = cmagique(c, n)
    print("==> permutation: ", b1, sep="")
    print("==> semi-magique: ", b2, sep="")
    print("==> cmagique: ", b3, sep="")

PGTMagicite()