import java.util.Scanner;

class PGTMagicite {

/**
  Taille maximale du tableau
*/
final static int TMAX = 100;

/**
  Somme partielle depuis une case
  @param[in] c - 
  @param[in] ideb - indice début ligne
  @param[in] jdeb - indice début colonne
  @param[in] iincr - incrément selon les lignes
  @param[in] jincr - incrément selon les colonnes
  @param[in] n - ordre de c
  @return La somme de n éléments de c en partant de (ideb,jdeb)
*/

public static int sommePartielle(final int[] c, int ideb, int jdeb, int iincr, int jincr, int n)
{
  int rs = 0;
  int ix = ideb;
  int jx = jdeb;
  for (int k = 1; k <= n; ++k)
  {
    rs += UtilsTM.evalCase(c,ix,jx,n);
    ix += iincr;
    jx += jincr;
  }
  return rs;
}

/**
  Prédicat de carre semi-magique
  @param[in] c - un TCarre
  @param[in] n - ordre de c
  @return Vrai si c est un carré semi-magique d'ordre n
*/

public static boolean semiCMagique(final int[] c, int n)
{
  boolean rs = true;
  int sth = n * (n * n + 1) / 2;
  int k;
  k = 1;
  while (k <= n && rs)
  {
    rs = rs && (sommePartielle(c,k,1,0,1,n) == sth);
    ++k;
  }
  k = 1;
  while (k <= n && rs)
  {
    rs = rs && (sommePartielle(c,1,k,1,0,n) == sth);
    ++k;
  }
  rs = rs && (sommePartielle(c,1,1,1,1,n) == sth);
  rs = rs && (sommePartielle(c,1,n,1,-1,n) == sth);
  return rs;
}

/**
  Prédicat de carré magique
  @param[in] c - un TCarre
  @param[in] n - ordre de c
  @return Vrai si c est un carré magique d'ordre n
*/

public static boolean cmagique(final int[] c, int n)
{
  boolean b1 = UtilsTBOpers.permutationTab(c,n * n);
  boolean b2 = semiCMagique(c,n);
  return (b1 && b2);
}

public static void main(String[] args)
{
  Scanner input = new Scanner(System.in);
  int[] c = new int[TMAX];
  int nelems = UtilsTB.saisirTab(c);
  int n;
  System.out.print("Ordre n? ");
  n = input.nextInt();
  UtilsTM.afficherCarre(c,n);
  
  boolean b1 = UtilsTBOpers.permutationTab(c,n * n);
  boolean b2 = semiCMagique(c,n);
  boolean b3 = cmagique(c,n);
  System.out.println("==> permutation: " + b1);
  System.out.println("==> semi-magique: " + b2);
  System.out.println("==> cmagique: " + b3);
}

}
