#include <iostream>
using namespace std;

/**
  Taille maximale du tableau
*/

const int TMAX = 100;

/**
  Tableau d'entiers
*/

using ITableau = int[TMAX];

/**
  Représente un Carré
*/

using TCarre = ITableau;

#include "UtilsTM.cpp"
#include "UtilsTB.cpp"
#include "UtilsTBOpers.cpp"

/**
  Somme partielle depuis une case
  @param[in] c - 
  @param[in] ideb - indice début ligne
  @param[in] jdeb - indice début colonne
  @param[in] iincr - incrément selon les lignes
  @param[in] jincr - incrément selon les colonnes
  @param[in] n - ordre de c
  @return La somme de n éléments de c en partant de (ideb,jdeb)
*/

int sommePartielle(const TCarre& c, int ideb, int jdeb, int iincr, int jincr, int n)
{
  int rs = 0;
  int ix = ideb;
  int jx = jdeb;
  for (int k = 1; k <= n; ++k)
  {
    rs += UtilsTM::evalCase(c,ix,jx,n);
    ix += iincr;
    jx += jincr;
  }
  return rs;
}

/**
  Prédicat de carre semi-magique
  @param[in] c - un TCarre
  @param[in] n - ordre de c
  @return Vrai si c est un carré semi-magique d'ordre n
*/

bool semiCMagique(const TCarre& c, int n)
{
  bool rs = true;
  int sth = n * (n * n + 1) / 2;
  int k;
  k = 1;
  while (k <= n && rs)
  {
    rs = rs && (sommePartielle(c,k,1,0,1,n) == sth);
    ++k;
  }
  k = 1;
  while (k <= n && rs)
  {
    rs = rs && (sommePartielle(c,1,k,1,0,n) == sth);
    ++k;
  }
  rs = rs && (sommePartielle(c,1,1,1,1,n) == sth);
  rs = rs && (sommePartielle(c,1,n,1,-1,n) == sth);
  return rs;
}

/**
  Prédicat de carré magique
  @param[in] c - un TCarre
  @param[in] n - ordre de c
  @return Vrai si c est un carré magique d'ordre n
*/

bool cmagique(const TCarre& c, int n)
{
  bool b1 = UtilsTBOpers::permutationTab(c,n * n);
  bool b2 = semiCMagique(c,n);
  return (b1 && b2);
}

int main()
{
  TCarre c;
  int nelems = UtilsTB::saisirTab(c);
  int n;
  cout<<"Ordre n? ";
  cin>>n;
  UtilsTM::afficherCarre(c,n);
  
  bool b1 = UtilsTBOpers::permutationTab(c,n * n);
  bool b2 = semiCMagique(c,n);
  bool b3 = cmagique(c,n);
  cout<<"==> permutation: "<<b1<<endl;
  cout<<"==> semi-magique: "<<b2<<endl;
  cout<<"==> cmagique: "<<b3<<endl;
}
