import UtilsTM
TMAX = 100
""" Taille maximale du tableau """


def saisirOrdreCarre(nmax):
    """  Saisit l'ordre (impair) d'un TCarre
 
     :param nmax: nombre maximum de cellules du TCarre
     :return: l'ordre impair du TCarre
    """
    n = 0
    while not (n >= 1 and n % 2 == 1 and n * n <= nmax):
        n = int(input("Ordre impair du carre? "))
    return n


def suivant(k, n):
    """  Suivant dans l'ensemble circulaire [1..n]
 
     :param k: un entier
     :param n: un entier
     :return: le suivant de k dans l'ensemble circulaire [1..n]
    """
    return (1 if k >= n else k + 1)


def precedent(k, n):
    """  Précédent dans l'ensemble circulaire [1..n]
 
     :param k: un entier
     :param n: un entier
     :return: le précédent de k dans l'ensemble circulaire [1..n]
    """
    return (n if k == 1 else k - 1)


def creerCMagique1(c, n):
    """  Crée un carré magique
 
     :param c: un TCarre
     :param n: ordre de c
    """
    UtilsTM.initialiserCarre(c, n)
    nxn = n * n
    ix = 1
    jx = n // 2 + 1
    UtilsTM.fixerCase(c, ix, jx, n, 1)
    for valeur in range(2, nxn+1):
        isucc = precedent(ix, n)
        jsucc = suivant(jx, n)
        if UtilsTM.evalCase(c, isucc, jsucc, n) == 0:
            ix, jx = isucc, jsucc
        else:
            ix = suivant(ix, n)
        UtilsTM.fixerCase(c, ix, jx, n, valeur)


def creerCMagique2(c, n):
    """  Crée un carré magique (méthode 2)
 
     :param c: un TCarre
     :param n: ordre de c
    """
    UtilsTM.initialiserCarre(c, n)
    nxn = n * n
    ix = (n + 1) // 2 + 1
    jx = (n + 1) // 2
    UtilsTM.fixerCase(c, ix, jx, n, 1)
    for valeur in range(2, nxn+1):
        isucc = suivant(ix, n)
        jsucc = suivant(jx, n)
        if UtilsTM.evalCase(c, isucc, jsucc, n) == 0:
            ix, jx = isucc, jsucc
        else:
            ix = suivant(isucc, n)
        UtilsTM.fixerCase(c, ix, jx, n, valeur)


def PGCMagique():
    n = saisirOrdreCarre(TMAX)
    c = [0 for x in range(TMAX)]
    
    print("CMagique1")
    creerCMagique1(c, n)
    UtilsTM.afficherCarre(c, n)
    
    print("CMagique2")
    creerCMagique2(c, n)
    UtilsTM.afficherCarre(c, n)

PGCMagique()