import java.util.Scanner;

class PGCMagique {

/**
  Taille maximale du tableau
*/
final static int TMAX = 100;

/**
  Saisit l'ordre (impair) d'un TCarre
  @param[in] nmax - nombre maximum de cellules du TCarre
  @return l'ordre impair du TCarre
*/

public static int saisirOrdreCarre(int nmax)
{
  Scanner input = new Scanner(System.in);
  int n = 0;
  while (!(n >= 1 && n % 2 == 1 && n * n <= nmax))
  {
    System.out.print("Ordre impair du carre? ");
    n = input.nextInt();
  }
  return n;
}

/**
  Suivant dans l'ensemble circulaire [1..n]
  @param[in] k - un entier
  @param[in] n - un entier
  @return le suivant de k dans l'ensemble circulaire [1..n]
*/

public static int suivant(int k, int n)
{
  return (k >= n ? 1 : k + 1);
}

/**
  Précédent dans l'ensemble circulaire [1..n]
  @param[in] k - un entier
  @param[in] n - un entier
  @return le précédent de k dans l'ensemble circulaire [1..n]
*/

public static int precedent(int k, int n)
{
  return (k == 1 ? n : k - 1);
}

/**
  Crée un carré magique
  @param[out] c - un TCarre
  @param[in] n - ordre de c
*/

public static void creerCMagique1(int[] c, int n)
{
  UtilsTM.initialiserCarre(c,n);
  int nxn = n * n;
  int ix = 1;
  int jx = n / 2 + 1;
  UtilsTM.fixerCase(c,ix,jx,n,1);
  for (int valeur = 2; valeur <= nxn; ++valeur)
  {
    int isucc = precedent(ix,n);
    int jsucc = suivant(jx,n);
    if (UtilsTM.evalCase(c,isucc,jsucc,n) == 0)
    {
      ix = isucc;
      jx = jsucc;
    }
    else
    {
      ix = suivant(ix,n);
    }
    UtilsTM.fixerCase(c,ix,jx,n,valeur);
  }
}

/**
  Crée un carré magique (méthode 2)
  @param[out] c - un TCarre
  @param[in] n - ordre de c
*/

public static void creerCMagique2(int[] c, int n)
{
  UtilsTM.initialiserCarre(c,n);
  int nxn = n * n;
  int ix = (n + 1) / 2 + 1;
  int jx = (n + 1) / 2;
  UtilsTM.fixerCase(c,ix,jx,n,1);
  for (int valeur = 2; valeur <= nxn; ++valeur)
  {
    int isucc = suivant(ix,n);
    int jsucc = suivant(jx,n);
    if (UtilsTM.evalCase(c,isucc,jsucc,n) == 0)
    {
      ix = isucc;
      jx = jsucc;
    }
    else
    {
      ix = suivant(isucc,n);
    }
    UtilsTM.fixerCase(c,ix,jx,n,valeur);
  }
}

public static void main(String[] args)
{
  int n = saisirOrdreCarre(TMAX);
  int[] c = new int[TMAX];
  
  System.out.println("CMagique1");
  creerCMagique1(c,n);
  UtilsTM.afficherCarre(c,n);
  
  System.out.println("CMagique2");
  creerCMagique2(c,n);
  UtilsTM.afficherCarre(c,n);
}

}
