#include <iostream>
using namespace std;

/**
  Taille maximale du tableau
*/

const int TMAX = 100;

/**
  Tableau d'entiers
*/

using ITableau = int[TMAX];

/**
  Représente un Carré
*/

using TCarre = ITableau;

#include "UtilsTM.cpp"

/**
  Saisit l'ordre (impair) d'un TCarre
  @param[in] nmax - nombre maximum de cellules du TCarre
  @return l'ordre impair du TCarre
*/

int saisirOrdreCarre(int nmax)
{
  int n = 0;
  while (!(n >= 1 && n % 2 == 1 && n * n <= nmax))
  {
    cout<<"Ordre impair du carre? ";
    cin>>n;
  }
  return n;
}

/**
  Suivant dans l'ensemble circulaire [1..n]
  @param[in] k - un entier
  @param[in] n - un entier
  @return le suivant de k dans l'ensemble circulaire [1..n]
*/

int suivant(int k, int n)
{
  return (k >= n ? 1 : k + 1);
}

/**
  Précédent dans l'ensemble circulaire [1..n]
  @param[in] k - un entier
  @param[in] n - un entier
  @return le précédent de k dans l'ensemble circulaire [1..n]
*/

int precedent(int k, int n)
{
  return (k == 1 ? n : k - 1);
}

/**
  Crée un carré magique
  @param[out] c - un TCarre
  @param[in] n - ordre de c
*/

void creerCMagique1(TCarre& c, int n)
{
  UtilsTM::initialiserCarre(c,n);
  int nxn = n * n;
  int ix = 1;
  int jx = n / 2 + 1;
  UtilsTM::fixerCase(c,ix,jx,n,1);
  for (int valeur = 2; valeur <= nxn; ++valeur)
  {
    int isucc = precedent(ix,n);
    int jsucc = suivant(jx,n);
    if (UtilsTM::evalCase(c,isucc,jsucc,n) == 0)
    {
      ix = isucc;
      jx = jsucc;
    }
    else
    {
      ix = suivant(ix,n);
    }
    UtilsTM::fixerCase(c,ix,jx,n,valeur);
  }
}

/**
  Crée un carré magique (méthode 2)
  @param[out] c - un TCarre
  @param[in] n - ordre de c
*/

void creerCMagique2(TCarre& c, int n)
{
  UtilsTM::initialiserCarre(c,n);
  int nxn = n * n;
  int ix = (n + 1) / 2 + 1;
  int jx = (n + 1) / 2;
  UtilsTM::fixerCase(c,ix,jx,n,1);
  for (int valeur = 2; valeur <= nxn; ++valeur)
  {
    int isucc = suivant(ix,n);
    int jsucc = suivant(jx,n);
    if (UtilsTM::evalCase(c,isucc,jsucc,n) == 0)
    {
      ix = isucc;
      jx = jsucc;
    }
    else
    {
      ix = suivant(isucc,n);
    }
    UtilsTM::fixerCase(c,ix,jx,n,valeur);
  }
}

int main()
{
  int n = saisirOrdreCarre(TMAX);
  TCarre c;
  
  cout<<"CMagique1"<<endl;
  creerCMagique1(c,n);
  UtilsTM::afficherCarre(c,n);
  
  cout<<"CMagique2"<<endl;
  creerCMagique2(c,n);
  UtilsTM::afficherCarre(c,n);
}
