#include <iostream>
#include <ctime>
using namespace std;
#include "Jeu421.cpp"

/**
  @test
*/
void test_stats()
{
  int n;
  cout << "Nombre de lancers? ";
  cin >> n;
  int n421 = 0, nbrelans = 0, ntierces = 0, nautres = 0;
  for (int j = 1; j <= n; ++j)
  {
    int de1 = jetDe();
    int de2 = jetDe();
    int de3 = jetDe();
    decroitre3i(de1, de2, de3);
    if (est421(de1, de2, de3))
    {
      ++n421;
    }
    else if (brelan(de1, de2, de3))
    {
      ++nbrelans;
    }
    else if (tierce(de1, de2, de3))
    {
      ++ntierces;
    }
    else
    {
      ++nautres;
    }
  }
  cout<<"==> Proba 421    : "<<n421*100.0 / n<<"%"<<endl;
  cout<<"==> Proba brelan : "<<nbrelans*100.0 / n<<"%"<<endl;
  cout<<"==> Proba tierce : "<<ntierces*100.0 / n<<"%"<<endl;
  cout<<"==> Proba rien   : "<<nautres*100.0 / n<<"%"<<endl;
}

/**
  Saisit de la strategie
  @param[out] st - numero de la strategie
  @param[in] n - numero du joueur
*/
void saisirStrategie(int& st, int n)
{
  cout<<"Strategie du joueur "<<n<<endl;
  cout<<"0 - Manuel"<<endl;
  cout<<"1 - Naif"<<endl;
  cout<<"2 - Recherche 421"<<endl;
  cout<<"3 - Recherche brelan"<<endl;
  cout<<"4 - Recherche tierce"<<endl;
  cout<<"5 - Strategie preference"<<endl;
  do{
    cout<<"choix: entier dans 0..5? ";
    cin>>st;
  } while (not(0 <= st and st <= 5));
}

/**
  Effectue un tour de jeu, strategie naive
  @param[out] nj - nombre de jetons de la combinaison
  @param[out] s - eval de la combinaison
*/
void jouerTourNaif(int& nj, int& s)
{
  int d1, d2, d3;
  d1 = jetDe();
  d2 = jetDe();
  d3 = jetDe();
  decroitre3i(d1, d2, d3);
  cout<<"Combinaison finale = "<<d1<<d2<<d3<<endl;
  nj = njetons(d1, d2, d3);
  s = evalcmb(d1, d2, d3);
}

/**
  Rejoue un tour a la recherche du 421
  @param[in,out] d1 - valeur du premier de
  @param[in,out] d2 - valeur du deuxième de
  @param[in,out] d3 - valeur du troisième de
  @pre (d1,d2,d3) est ordonne decroissant et n'est pas un 421
*/
void rejouerTour421(int& d1, int& d2, int& d3)
{
  // Si d1 n'est pas un 4, regarde s'il y a un 4 parmi d2 ou d3
  // Si oui le permute avec d1 pour qu'en d1 on ait un 4
  if (d1 != 4)
  {
    if (d2 == 4)
    {
      permuter2i(d1, d2);
    }
    else if (d3 == 4)
    {
      permuter2i(d1, d3);
    }
  }
  // Si d2 n'est pas un 2, regarde s'il y a un 2 en d3.
  // Si oui, le permute avec d3 pour qu'en d2 on ait un 2
  if (d2 != 2)
  {
    if (d3 == 2)
    {
      permuter2i(d2, d3);
    }
  }
  // Ici on devrait avoir un debut de 421. Si c'est pas le cas,
  // on relance chacun des des pour tenter d'obtenir un 421
  if (d1 != 4)
  {
    d1 = jetDe();
  }
  if (d2 != 2)
  {
    d2 = jetDe();
  }
  if (d3 != 1)
  {
    d3 = jetDe();
  }
}

/**
  Effectue un tour de jeu, recherche du 421
  @param[out] nj - nombre de jetons de la combinaison
  @param[out] s - eval de la combinaison
*/
void jouerTour421(int& nj, int& s)
{
  int d1, d2, d3;
  d1 = jetDe();
  d2 = jetDe();
  d3 = jetDe();
  decroitre3i(d1, d2, d3);
  int nlancers = 1;
  while (nlancers <= 3 and not est421(d1,d2,d3))
  {
    rejouerTour421(d1,d2,d3);
    decroitre3i(d1,d2,d3);
    ++nlancers;
  }
  cout<<"Combinaison finale = "<<d1<<d2<<d3<<endl;
  nj = njetons(d1, d2, d3);
  s = evalcmb(d1, d2, d3);
}

/**
  Rejoue un tour a la recherche d'un brelan
  @param[in,out] d1 - valeur du premier de
  @param[in,out] d2 - valeur du deuxième de
  @param[in,out] d3 - valeur du troisième de
  @pre (d1,d2,d3) est ordonne decroissant et n'est pas un brelan
*/
void rejouerTourBrelan(int& d1, int& d2, int& d3)
{
  if (d1 == d2)
  {
    d3 = jetDe();
  }
  else if (d2 == d3)
  {
    d1 = jetDe();
  }
  else if (d1 == d3)
  {
    d2 = jetDe();
  }
  else
  {
    // on en rejoue au moins deux
    d2 = jetDe();
    d3 = jetDe();
  }
}

/**
  Effectue un tour de jeu, recherche du brelan
  @param[out] nj - nombre de jetons de la combinaison
  @param[out] s - eval de la combinaison
*/
void jouerTourBrelan(int& nj, int& s)
{
  int d1, d2, d3;
  d1 = jetDe();
  d2 = jetDe();
  d3 = jetDe();
  decroitre3i(d1, d2, d3);
  int nlancers = 1;
  while (nlancers <= 3 and not brelan(d1,d2,d3))
  {
    rejouerTourBrelan(d1,d2,d3);
    decroitre3i(d1,d2,d3);
    ++nlancers;
  }
  cout<<"Combinaison finale = "<<d1<<d2<<d3<<endl;
  nj = njetons(d1, d2, d3);
  s = evalcmb(d1, d2, d3);
}

/**
  Rejoue un tour a la recherche d'une tierce
  @param[in,out] d1 - valeur du premier de
  @param[in,out] d2 - valeur du deuxième de
  @param[in,out] d3 - valeur du troisième de
  @pre (d1,d2,d3) est ordonne decroissant et n'est pas une tierce
*/
void rejouerTourTierce(int& d1, int& d2, int& d3)
{
  if (d1 == d2+1)
  {
    d3 = jetDe();
  }
  else if (d2 == d3+1)
  {
    d1 = jetDe();
  }
  else if (d1 == d3+2)
  {
    d2 = jetDe();
  }
  else
  {
    // on rejoue le max et le min
    d1 = jetDe();
    d3 = jetDe();
  }
}

/**
  Effectue un tour de jeu, recherche de tierce
  @param[out] nj - nombre de jetons de la combinaison
  @param[out] s - eval de la combinaison
*/
void jouerTourTierce(int& nj, int& s)
{
  int d1, d2, d3;
  d1 = jetDe();
  d2 = jetDe();
  d3 = jetDe();
  decroitre3i(d1, d2, d3);
  int nlancers = 1;
  while (nlancers <= 3 and not tierce(d1,d2,d3))
  {
    rejouerTourTierce(d1,d2,d3);
    decroitre3i(d1,d2,d3);
    ++nlancers;
  }
  cout<<"Combinaison finale = "<<d1<<d2<<d3<<endl;
  nj = njetons(d1, d2, d3);
  s = evalcmb(d1, d2, d3);
}

/**
  Conversion d'un booleen en un entier (vrai=1, faux=0)
  @param[in] b - un booleen
  @return 1 si b est vrai, 0 sinon
*/
int evalBool(bool b)
{
  if (b)
  {
    return 1;
  }
  else
  {
    return 0;
  }
}

/**
  Nombre de des a relancer pour obtenir 421
  @param[in] d1 - valeur du premier de
  @param[in] d2 - valeur du deuxième de
  @param[in] d3 - valeur du troisième de
  @return le Nombre de des a relancer pour obtenir 421
*/
int combien421(int d1, int d2, int d3)
{
  // même strategie que rejouerTour421
  if (d1 != 4)
  {
    if (d2 == 4)
    {
      permuter2i(d1, d2);
    }
    else if (d3 == 4)
    {
      permuter2i(d1, d3);
    }
  }
  if (d2 != 2)
  {
    if (d3 == 2)
    {
      permuter2i(d2, d3);
    }
  }
  // Evalue chacun des des different de 421
  return (evalBool(d1 != 4) + evalBool(d2 != 2) + evalBool(d3 != 1));
}

/**
  Nombre de des a relancer pour obtenir un brelan
  @param[in] d1 - valeur du premier de
  @param[in] d2 - valeur du deuxième de
  @param[in] d3 - valeur du troisième de
  @return le Nombre de des a relancer pour obtenir un brelan
*/
int combienBrelan(int d1, int d2, int d3)
{
  if (d1 == d2 or d2 == d3 or d1 == d3)
  {
    return 1;
  }
  else
  {
    return 2;
  }
}

/**
  Nombre de des a relancer pour obtenir une tierce
  @param[in] d1 - valeur du premier de
  @param[in] d2 - valeur du deuxième de
  @param[in] d3 - valeur du troisième de
  @return le Nombre de des a relancer pour obtenir une tierce
*/
int combienTierce(int d1, int d2, int d3)
{
  if (d1 == d2+1 or d2 == d3+1 or d1 == d3+2)
  {
    return 1;
  }
  else
  {
    return 2;
  }
}

/**
  Test de combinaison
  @param[in] d1 - valeur du premier de
  @param[in] d2 - valeur du deuxième de
  @param[in] d3 - valeur du troisième de
  @return Vrai si (d1,d2,d3) est un 421, un brelan ou une tierce
*/
bool combinaison(int d1, int d2, int d3)
{
  return est421(d1,d2,d3) or brelan(d1,d2,d3) or tierce(d1,d2,d3);
}

/**
  Effectue un tour de jeu, recherche de preference
  @param[out] nj - nombre de jetons de la combinaison
  @param[out] s - eval de la combinaison
*/
void jouerTourPref(int& nj, int& s)
{
  int d1, d2, d3;
  d1 = jetDe();
  d2 = jetDe();
  d3 = jetDe();
  decroitre3i(d1, d2, d3);
  int nlancers = 1;
  while (nlancers <= 3 && !combinaison(d1,d2,d3))
  {
    int c421 = combien421(d1,d2,d3);
    int cbrelan = combienBrelan(d1,d2,d3);
    int ctierce = combienTierce(d1,d2,d3);
    if (c421 == 1)
    {
      rejouerTour421(d1,d2,d3);
    }
    else if (cbrelan == 1)
    {
      rejouerTourBrelan(d1,d2,d3);
    }
    else if (c421 == 2)
    {
      rejouerTour421(d1,d2,d3);
    }
    else if (ctierce == 1)
    {
      rejouerTourTierce(d1,d2,d3);
    }
    else
    {
      rejouerTour421(d1,d2,d3);
    }
    decroitre3i(d1,d2,d3);
    ++nlancers;
  }
  cout<<"Combinaison finale = "<<d1<<d2<<d3<<endl;
  nj = njetons(d1, d2, d3);
  s = evalcmb(d1, d2, d3);
}

/**
  Effectue un tour de jeu avec strategie de jeu
  @param[out] nj - nombre de jetons de la combinaison
  @param[out] s - eval de la combinaison
  @param[in] st - numero de la strategie
*/
void jouerTourST(int& nj, int& s, int st)
{
  switch(st)
  {
    case 0:
      jouerTour(nj, s);
      break;
    case 1:
      jouerTourNaif(nj, s);
      break;
    case 2:
      jouerTour421(nj, s);
      break;
    case 3:
      jouerTourBrelan(nj, s);
      break;
    case 4:
      jouerTourTierce(nj, s);
      break;
    case 5:
      jouerTourPref(nj, s);
      break;
  }
}

/**
  Procedure de test
*/
void test_jeu()
{
  int st1;
  saisirStrategie(st1, 1);
  int st2;
  saisirStrategie(st2, 2);
  int njtot1, njtot2, nj1, s1, nj2, s2;
  cout<<"Nombre de jetons? ";
  cin >> njtot1;
  njtot2 = njtot1;
  while (njtot1 > 0 and njtot2 > 0)
  {
    cout<<"==> Joueur 1 actif:"<<endl;
    jouerTourST(nj1, s1, st1);
    cout<<"==> Joueur 2 actif:"<<endl;
    jouerTourST(nj2, s2, st2);
    if (s1 == s2)
    {
      cout<<"cas d'egalite de combinaisons -- tour a vide... on recommence"<<endl;
    }
    else if (nj1 != nj2)
    {
      traiterJetonsDiff(nj1, nj2, njtot1, njtot2);
    }
    else
    {
      traiterJetonsEgaux(nj1, s1, s2, njtot1, njtot2);
    }
    cout<<"njtot1 = "<<njtot1<<", njtot2 = "<<njtot2<<endl;
  }
}

int main()
{
  srand(time(0));
  //test_stats();
  test_jeu();
}

