import random as rnd

def permuter2i(a, b):
    """  Permute les valeurs de deux entiers
 
     :param a: un entier
     :param b: un entier
     :return: le tuple (b,a)
    """
    return (b, a)


def decroitre2i(a, b):
    """  Ordonne deux entiers par ordre décroissant
 
     :param a: un entier
     :param b: un entier
     :return: un tuple (a,b) tel que a >= b
    """
    if a < b:
        a, b = permuter2i(a, b)
    return (a, b)


def decroitre3i(a, b, c):
    """  Ordonne trois entiers par ordre décroissant
 
     :param a: un entier
     :param b: un entier
     :param c: un entier
     :return: un tuple (a,b,c) tel que a >= b >= c
    """
    a, b = decroitre2i(a, b)
    b, c = decroitre2i(b, c)
    a, b = decroitre2i(a, b)
    return (a, b, c)


def tierce(a, b, c):
    """  Prédicat de tierce
 
     :param a: un entier
     :param b: un entier
     :param c: un entier tel que a >= b >= c
     :return: Vrai si (a,b,c) est une tierce, Faux sinon
    """
    return ((a == b + 1) and (b == c + 1))


def brelan(a, b, c):
    """  Prédicat de brelan
 
     :param a: un entier
     :param b: un entier
     :param c: un entier tel que a >= b >= c
     :return: Vrai si (a,b,c) est un brelan, Faux sinon
    """
    return (a == b and b == c)


def est421(a, b, c):
    """  Prédicat de 421
 
     :param a: un entier
     :param b: un entier
     :param c: un entier tel que a >= b >= c
     :return: Vrai si (a,b,c) est un 421, Faux sinon
    """
    return (a == 4 and b == 2 and c == 1)


def njetons(a, b, c):
    """  Nombre de jetons d'une combinaison
 
     :param a: un entier
     :param b: un entier
     :param c: un entier tel que a >= b >= c
     :return: Nombre de jetons de (a,b,c)
    """
    if brelan(a, b, c):
        return 5
    elif tierce(a, b, c):
        return 2
    elif est421(a, b, c):
        return 8
    else:
        return 1


def evalcmb(a, b, c):
    """  Valeur d'une combinaison
 
     :param a: un entier
     :param b: un entier
     :param c: un entier
     :return: Valeur de (a,b,c)
    """
    return (100 * a + 10 * b + c)


def jetDe():
    """  Simule le lancer d'un jet de dé
 
     :return: Valeur d'un dé à six faces
    """
    return rnd.randint(1, 6)


def relancer(de, n):
    """  Affiche la valeur du dé puis demande et relance si c'est le cas
 
     :param de: valeur du dé
     :param n: numéro du dé
     :return: valeur du dé
    """
    print("Valeur du ", n, "eme de = ", de, " (tapez 1 pour relancer)? ", sep="", end="")
    rejouer = int(input())
    if rejouer == 1:
        de = jetDe()
    return de


def jouerTour():
    """  Effectue un tour de jeu d'un joueur
 
     :return: le tuple (nombre de jetons,valeur de la combinaison)
    """
    d1, d2, d3 = jetDe(), jetDe(), jetDe()
    nlancers = 1
    print(nlancers, "eme jet -- Combinaison actuelle = ", d1, d2, d3, sep="")
    rejouer = int(input("Pour la rejouer, tapez 1 (autre==fin)? "))
    while nlancers <= 3 and rejouer == 1:
        d1 = relancer(d1, 1)
        d2 = relancer(d2, 2)
        d3 = relancer(d3, 3)
        nlancers += 1
        if nlancers <= 3:
            print(nlancers, "eme jet -- Combinaison actuelle = ", d1, d2, d3, sep="")
            rejouer = int(input("Pour la rejouer, tapez 1 (autre==fin)? "))
    print("Combinaison finale = ", d1, d2, d3, sep="")
    d1, d2, d3 = decroitre3i(d1, d2, d3)
    nj = njetons(d1, d2, d3)
    s = evalcmb(d1, d2, d3)
    return (nj, s)


def traiterJetonsDiff(nj1, nj2, njtot1, njtot2):
    """  Traite le cas de jetons différents
 
     :param nj1: nombre de jetons du jet du joueur 1
     :param nj2: nombre de jetons du jet du joueur 2
     :param njtot1: nombre total de jetons du joueur 1
     :param njtot2: nombre total de jetons du joueur 2
     :return: le tuple (njtot1,njtot2)
    """
    print("cas de jetons differents -- ", end="")
    if nj1 > nj2:
        print("joueur 1 gagnant")
        njtot1 -= nj1
        njtot2 += nj1
    else:
        print("joueur 2 gagnant")
        njtot1 += nj2
        njtot2 -= nj2
    return (njtot1, njtot2)


def traiterJetonsEgaux(nj, s1, s2, njtot1, njtot2):
    """  Traite le cas de jetons egaux
 
     :param nj: nombre de jetons du jet
     :param s1: valeur du jet du joueur 1
     :param s2: valeur du jet du joueur 2
     :param njtot1: nombre total de jetons du joueur 1
     :param njtot2: nombre total de jetons du joueur 2
     :return: le tuple (njtot1,njtot2)
    """
    print("cas de jetons egaux -- ", end="")
    if s1 > s2:
        print("joueur 1 gagnant")
        njtot1 -= nj
        njtot2 += nj
    else:
        print("joueur 2 gagnant")
        njtot1 += nj
        njtot2 -= nj
    return (njtot1, njtot2)

