import java.util.Scanner;
import java.util.Random;

public class Jeu421 {

/**
  Permute les valeurs de deux entiers
  @param[in,out] a - un entier
  @param[in,out] b - un entier
*/

public static void permuter2i(int[] a, int[] b)
{
  int tmp = a[0];
  a[0] = b[0];
  b[0] = tmp;
}

/**
  Ordonne deux entiers par ordre décroissant
  @param[in,out] a - un entier
  @param[in,out] b - un entier
  @post a >= b
*/

public static void decroitre2i(int[] a, int[] b)
{
  if (a[0] < b[0])
  {
    permuter2i(a,b);
  }
}

/**
  Ordonne trois entiers par ordre décroissant
  @param[in,out] a - un entier
  @param[in,out] b - un entier
  @param[in,out] c - un entier
  @post a >= b >= c
*/

public static void decroitre3i(int[] a, int[] b, int[] c)
{
  decroitre2i(a,b);
  decroitre2i(b,c);
  decroitre2i(a,b);
}

/**
  Prédicat de tierce
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Vrai si (a,b,c) est une tierce, Faux sinon
*/

public static boolean tierce(int a, int b, int c)
{
  return ((a == b + 1) && (b == c + 1));
}

/**
  Prédicat de brelan
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Vrai si (a,b,c) est un brelan, Faux sinon
*/

public static boolean brelan(int a, int b, int c)
{
  return (a == b && b == c);
}

/**
  Prédicat de 421
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Vrai si (a,b,c) est un 421, Faux sinon
*/

public static boolean est421(int a, int b, int c)
{
  return (a == 4 && b == 2 && c == 1);
}

/**
  Nombre de jetons d'une combinaison
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Nombre de jetons de (a,b,c)
*/

public static int njetons(int a, int b, int c)
{
  if (brelan(a,b,c))
  {
    return 5;
  }
  else if (tierce(a,b,c))
  {
    return 2;
  }
  else if (est421(a,b,c))
  {
    return 8;
  }
  else
  {
    return 1;
  }
}

/**
  Valeur d'une combinaison
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @return Valeur de (a,b,c)
*/

public static int evalcmb(int a, int b, int c)
{
  return (100 * a + 10 * b + c);
}

// Randomiseur
static Random rnd = new Random();

/**
  Simule le lancer d'un jet de dé
  @return Valeur d'un dé à six faces
*/

public static int jetDe()
{
  return rnd.nextInt(6) + 1;
}

/**
  Affiche la valeur du dé puis demande et relance s'il c'est le cas
  @param[in,out] de - valeur du dé
  @param[in] n - numero du dé
*/

public static void relancer(int[] de, int n)
{
  Scanner input = new Scanner(System.in);
  int rejouer;
  System.out.print("Valeur du " + n + "eme de = " + de[0] + " (tapez 1 pour relancer)? ");
  rejouer = input.nextInt();
  if (rejouer == 1)
  {
    de[0] = jetDe();
  }
}

/**
  Effectue un tour de jeu d'un joueur
  @param[out] nj - nombre de jetons
  @param[out] s - valeur de la combinaison
*/

public static void jouerTour(int[] nj, int[] s)
{
  Scanner input = new Scanner(System.in);
  int[] d1 = new int[1], d2 = new int[1], d3 = new int[1];
  d1[0] = jetDe();
  d2[0] = jetDe();
  d3[0] = jetDe();
  int nlancers = 1;
  System.out.println(nlancers + "eme jet -- Combinaison actuelle = " + d1[0] + d2[0] + d3[0]);
  int rejouer;
  System.out.print("Pour la rejouer, tapez 1 (autre==fin)? ");
  rejouer = input.nextInt();
  while (nlancers <= 3 && rejouer == 1)
  {
    relancer(d1,1);
    relancer(d2,2);
    relancer(d3,3);
    ++nlancers;
    if (nlancers <= 3)
    {
      System.out.println(nlancers + "eme jet -- Combinaison actuelle = " + d1[0] + d2[0] + d3[0]);
      System.out.print("Pour la rejouer, tapez 1 (autre==fin)? ");
      rejouer = input.nextInt();
    }
  }
  System.out.println("Combinaison finale = " + d1[0] + d2[0] + d3[0]);
  decroitre3i(d1,d2,d3);
  nj[0] = njetons(d1[0],d2[0],d3[0]);
  s[0] = evalcmb(d1[0],d2[0],d3[0]);
}

/**
  Traite le cas de jetons différents
  @param[in] nj1 - nombre de jetons du jet du joueur 1
  @param[in] nj2 - nombre de jetons du jet du joueur 2
  @param[in,out] njtot1 - nombre total de jetons du joueur 1
  @param[in,out] njtot2 - nombre total de jetons du joueur 2
*/

public static void traiterJetonsDiff(int nj1, int nj2, int[] njtot1, int[] njtot2)
{
  System.out.print("cas de jetons differents -- ");
  if (nj1 > nj2)
  {
    System.out.println("joueur 1 gagnant");
    njtot1[0] -= nj1;
    njtot2[0] += nj1;
  }
  else
  {
    System.out.println("joueur 2 gagnant");
    njtot1[0] += nj2;
    njtot2[0] -= nj2;
  }
}

/**
  Traite le cas de jetons egaux
  @param[in] nj - nombre de jetons du jet
  @param[in] s1 - valeur du jet du joueur 1
  @param[in] s2 - valeur du jet du joueur 2
  @param[in,out] njtot1 - nombre total de jetons du joueur 1
  @param[in,out] njtot2 - nombre total de jetons du joueur 2
*/

public static void traiterJetonsEgaux(int nj, int s1, int s2, int[] njtot1, int[] njtot2)
{
  System.out.print("cas de jetons egaux -- ");
  if (s1 > s2)
  {
    System.out.println("joueur 1 gagnant");
    njtot1[0] -= nj;
    njtot2[0] += nj;
  }
  else
  {
    System.out.println("joueur 2 gagnant");
    njtot1[0] += nj;
    njtot2[0] -= nj;
  }
}

}
