#ifndef JEU421
#define JEU421
#include <cstdlib>
using namespace std;

namespace Jeu421 {


/**
  Permute les valeurs de deux entiers
  @param[in,out] a - un entier
  @param[in,out] b - un entier
*/

void permuter2i(int& a, int& b)
{
  int tmp = a;
  a = b;
  b = tmp;
}

/**
  Ordonne deux entiers par ordre décroissant
  @param[in,out] a - un entier
  @param[in,out] b - un entier
  @post a >= b
*/

void decroitre2i(int& a, int& b)
{
  if (a < b)
  {
    permuter2i(a,b);
  }
}

/**
  Ordonne trois entiers par ordre décroissant
  @param[in,out] a - un entier
  @param[in,out] b - un entier
  @param[in,out] c - un entier
  @post a >= b >= c
*/

void decroitre3i(int& a, int& b, int& c)
{
  decroitre2i(a,b);
  decroitre2i(b,c);
  decroitre2i(a,b);
}

/**
  Prédicat de tierce
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Vrai si (a,b,c) est une tierce, Faux sinon
*/

bool tierce(int a, int b, int c)
{
  return ((a == b + 1) && (b == c + 1));
}

/**
  Prédicat de brelan
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Vrai si (a,b,c) est un brelan, Faux sinon
*/

bool brelan(int a, int b, int c)
{
  return (a == b && b == c);
}

/**
  Prédicat de 421
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Vrai si (a,b,c) est un 421, Faux sinon
*/

bool est421(int a, int b, int c)
{
  return (a == 4 && b == 2 && c == 1);
}

/**
  Nombre de jetons d'une combinaison
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @pre a >= b >= c
  @return Nombre de jetons de (a,b,c)
*/

int njetons(int a, int b, int c)
{
  if (brelan(a,b,c))
  {
    return 5;
  }
  else if (tierce(a,b,c))
  {
    return 2;
  }
  else if (est421(a,b,c))
  {
    return 8;
  }
  else
  {
    return 1;
  }
}

/**
  Valeur d'une combinaison
  @param[in] a - un entier
  @param[in] b - un entier
  @param[in] c - un entier
  @return Valeur de (a,b,c)
*/

int evalcmb(int a, int b, int c)
{
  return (100 * a + 10 * b + c);
}

/**
  Simule le lancer d'un jet de dé
  @return Valeur d'un dé à six faces
*/

int jetDe()
{
  return (rand()%6) + 1;
}

/**
  Affiche la valeur du dé puis demande et relance si c'est le cas
  @param[in,out] de - valeur du dé
  @param[in] n - numéro du dé
*/

void relancer(int& de, int n)
{
  int rejouer;
  cout<<"Valeur du "<<n<<"eme de = "<<de<<" (tapez 1 pour relancer)? ";
  cin>>rejouer;
  if (rejouer == 1)
  {
    de = jetDe();
  }
}

/**
  Effectue un tour de jeu d'un joueur
  @param[out] nj - nombre de jetons
  @param[out] s - valeur de la combinaison
*/

void jouerTour(int& nj, int& s)
{
  int d1 = jetDe(), d2 = jetDe(), d3 = jetDe();
  int nlancers = 1;
  cout<<nlancers<<"eme jet -- Combinaison actuelle = "<<d1<<d2<<d3<<endl;
  int rejouer;
  cout<<"Pour la rejouer, tapez 1 (autre==fin)? ";
  cin>>rejouer;
  while (nlancers <= 3 && rejouer == 1)
  {
    relancer(d1,1);
    relancer(d2,2);
    relancer(d3,3);
    ++nlancers;
    if (nlancers <= 3)
    {
      cout<<nlancers<<"eme jet -- Combinaison actuelle = "<<d1<<d2<<d3<<endl;
      cout<<"Pour la rejouer, tapez 1 (autre==fin)? ";
      cin>>rejouer;
    }
  }
  cout<<"Combinaison finale = "<<d1<<d2<<d3<<endl;
  decroitre3i(d1,d2,d3);
  nj = njetons(d1,d2,d3);
  s = evalcmb(d1,d2,d3);
}

/**
  Traite le cas de jetons différents
  @param[in] nj1 - nombre de jetons du jet du joueur 1
  @param[in] nj2 - nombre de jetons du jet du joueur 2
  @param[in,out] njtot1 - nombre total de jetons du joueur 1
  @param[in,out] njtot2 - nombre total de jetons du joueur 2
*/

void traiterJetonsDiff(int nj1, int nj2, int& njtot1, int& njtot2)
{
  cout<<"cas de jetons differents -- ";
  if (nj1 > nj2)
  {
    cout<<"joueur 1 gagnant"<<endl;
    njtot1 -= nj1;
    njtot2 += nj1;
  }
  else
  {
    cout<<"joueur 2 gagnant"<<endl;
    njtot1 += nj2;
    njtot2 -= nj2;
  }
}

/**
  Traite le cas de jetons egaux
  @param[in] nj - nombre de jetons du jet
  @param[in] s1 - valeur du jet du joueur 1
  @param[in] s2 - valeur du jet du joueur 2
  @param[in,out] njtot1 - nombre total de jetons du joueur 1
  @param[in,out] njtot2 - nombre total de jetons du joueur 2
*/

void traiterJetonsEgaux(int nj, int s1, int s2, int& njtot1, int& njtot2)
{
  cout<<"cas de jetons egaux -- ";
  if (s1 > s2)
  {
    cout<<"joueur 1 gagnant"<<endl;
    njtot1 -= nj;
    njtot2 += nj;
  }
  else
  {
    cout<<"joueur 2 gagnant"<<endl;
    njtot1 += nj;
    njtot2 -= nj;
  }
}

}
#endif
